
'use client';
import { Dialog } from "@headlessui/react";
import { useState } from "react";

type VideoModalProps = {
  thumbnail: string;
  videoSrc: string;
};

export default function VideoModal({ thumbnail, videoSrc }: VideoModalProps) {
  const [isOpen, setIsOpen] = useState(false);

  if (!thumbnail || !videoSrc) return null; // Safety check

  return (
    <>
      <button
        onClick={() => setIsOpen(true)}
        className="relative block w-full focus:outline-none"
      >
        {/* Thumbnail */}
        <figure className="modal-figure">
          <img
            src={thumbnail}
            alt="Video Thumbnail"
            className="video-thumb w-full h-[456px] object-cover object-center rounded-tl-[20px] rounded-bl-[20px]"
          />
        </figure>

        {/* Play Icon Overlay (exact match from your link) */}
        <div className="absolute inset-0 flex items-center justify-center">
          <img
            src="/images/icon-card-play.svg"
            alt="Play Button"
            className="w-16 h-16"
          />
        </div>
      </button>

      {/* Modal Dialog */}
      <Dialog
        open={isOpen}
        onClose={() => setIsOpen(false)}
        className="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/60"
      >
        <Dialog.Panel className="relative w-full max-w-3xl overflow-hidden rounded-lg bg-black">
          {/* Video player */}
          <div className="relative pt-[56.25%]"> {/* 16:9 ratio */}
            <video
              src={videoSrc}
              controls
              autoPlay
              className="absolute inset-0 w-full h-full object-cover"
            />
          </div>

          {/* Close button */}
          <button
            onClick={() => setIsOpen(false)}
            className="absolute top-4 right-4 text-white text-xl font-bold"
          >
            &times;
          </button>
        </Dialog.Panel>
      </Dialog>
    </>
  );
}
