import VideoModal from './VideoModal'
import Image from 'next/image'
import Link from 'next/link'
export default function ListedWebminars() {
	return (
		<>
		<section className="listed-webminars bg-[#f5f5f5]">
			<div className="container mx-auto px-4">
				<div className="listed-webminars">
					<div className="grid gap-6 md:grid-cols-2 xl:grid-cols-3">
	        {/* Card 1 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-02.jpg" alt=""
										width={400}
										height={250}
									/>
								</figure>
							</Link>
							<div className="news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 2 with VideoModal */}
						<div className="news-card-sm video-iconcard bg-white rounded-xl overflow-hidden shadow">
							<VideoModal
								thumbnail="/images/webinars-card-03.jpg"
								videoSrc="/videos/our_stories__video.mp4"
							/>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 3 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link className="card__link" href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-04.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 4 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-05.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 5*/}
						<div className="news-card-sm video-iconcard bg-white rounded-xl overflow-hidden shadow">
							<Link href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-06.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 6 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link className="card__link" href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-07.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 7 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link href="#">
								<figure>
									<Image className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-08.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 8 */}
						<div className="news-card-sm video-iconcard bg-white rounded-xl overflow-hidden shadow">
							<Link href="webinars-and-videos.html">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-09.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>

	        {/* Card 9 */}
						<div className="news-card-sm bg-white rounded-xl overflow-hidden shadow">
							<Link className="card__link" href="#">
								<figure>
									<Image 
										className="card-image w-full h-auto object-cover" 
										src="/images/webinars-card-10.jpg" alt=""
										width={400}
										height={250} 
									/>
								</figure>
							</Link>
							<div className="news-details news-details p-[30px]">
								<div className="news-time flex gap-2 flex-wrap text-sm font-medium text-[#a39fac] mb-[10px]">
									<span className="date">March 25. 2024</span>
									<span>|</span>
									<Link href="#" className="webminar-tag text-[#731fff] underline">YourReviews Webinar</Link>
								</div>
								<h6 className="mt-4 font-bold text-black max-l:text-[20px] text-[22px] font-nunito leading-[1.26] tracking-tightish">
									Philadelphians are in hot water, uncovering legal and financial problems when ignoring the fine print 
								</h6>
								<Link className="primary-link with-arrow inline-block !mt-5 pr-[80px] !underline" href="#">Learn More</Link>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		</>
		);
}