import Link from 'next/link'

interface ProductHeaderProps {
  name: string;
  description: string;
}

export default function ProductHeader({ name, description }: ProductHeaderProps){
	return(
		<>
		<div className="product-name flex max-md:flex-col max-md:items-start max-md:gap-y-[12px] 
            justify-between items-center mb-[23px] mt-[16px]">
            <div className="product-name--left">
                <h4 className="max-md:text-[26px] max-xl:text-[30px] llg:text-[36px] mt-[10px] font-bold text-[#323232] !leading-[1.20]">
                    {name}
                </h4>
                <p className="text-[#666] text-sm font-normal !leading-[1.43]">
                    {description}
                </p>
            </div>
            <div className="product-name--right flex gap-[4px]">
                <Link className="ms-btn primary-border btn-sm !py-[10px] max-l:!text-[14px] 
                    max-md:!py-[8px] max-md:!px-[15px] max-md:!text-[13px] !text-[15px]" href="/#">
                    Follow
                </Link>
                <Link className="ms-btn primary-border btn-sm !py-[10px] max-l:!text-[14px] 
                    max-md:!py-[8px] max-md:!px-[15px] max-md:!text-[13px] !text-[15px] !flex !gap-[4px] items-center" href="/#">
                    <i className="icon-share"></i> 
                    Share
                </Link>
            </div>
        </div>
		</>
		);
}