import Image from 'next/image'
import Link from 'next/link'

export default function CtaBlock(){
	return(
		<>
		<section className="cta-block py-[45px] bg-white max-xl:text-center">
		    <div className="container mx-auto px-4">
		        <div className="cta-block-holder max-w-[1130px] mx-auto">
		            <div className="row flex flex-wrap -mx-3 -mt-6">
		                <div className="w-full lg:w-4/12 px-3 mt-6">
		                    <figure className="cta-block-img">
		                        <Image src="/images/vector-partners.png" alt=""
		                        	   width={519}
		                        	   height={351}
		                        	   className="max-l:mx-auto max-xl:max-w-[245px] max-w-[345px] w-full"
		                        />
		                    </figure>
		                </div>
		                <div className="w-full lg:w-8/12 px-3 mt-6">
		                    <div className="cta-block-content">
		                        <h3 className="mb-[23px] max-sm:text-[28px] max-md:text-[32px] max-xl:text-4xl text-[40px] font-nunito font-bold text-[#323232] !leading-[1.20]">
		                        	Apply to join the YourReview Partner Program Today!</h3>
		                        <Link href="/#" className="ms-btn primary-solid btn-lg max-l:!text-[15px] max-l:!py-[16px] max-l:!px-[20px] 
		                        	!text-[18px] !py-[20px] !px-[30px]">
		                        	Become a YourReview Partner
		                    	</Link>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}