import Link from 'next/link'

export default function HowCanHelp(){
	return(
		<>
		<section className="how-can-help-section mt-[60px] pb-[85px]">
			<div className="container mx-auto px-4">
				<div className="how-can-help grid grid-cols-3 gap-[20px] text-left
					max-xl:grid-cols-2 max-md:grid-cols-1">
		            <div className="quick-card card--1 p-[35px_40px_48px_49px] rounded-[24px] 
		            	bg-white row-span-2 max-xl:col-span-2 max-md:p-[35px_35px_44px_35px] max-md:col-span-1">
		                <img src="images/icon-howcan-help.svg" alt="" className="mb-[28px]" />
		                <h4 className="mb-[16px] text-[#323232] text-[32px] font-bold font-nunito
		                	!leading-[1.20] max-xl:text-3xl max-md:text-[26px]">
		                	How can we help?
		                </h4>
		                <p className="text-left text-[#808080] text-base font-medium !leading-[1.50] min-h-[55px] mt-[5px]
		                	max-md:mt-[10px] max-md:min-h-[auto]">
		                	Lorem Ipsum is simply dummy text of the printing and typesetting industry. 
		                	Lorem Ipsum has been the industry's standard dummy text ever since the 1500s,
		                </p>
		            </div>
		            <div className="quick-card card--2 p-[35px_40px_48px_49px] bg-white rounded-[24px] 
		            	max-md:p-[35px_35px_44px_35px]">
		                <h6 className="text-[#000] text-xl font-bold !leading-[1.51] mb-[10px]">Help Center</h6>
		                <p className="text-left text-[#808080] text-base font-medium !leading-[1.50] min-h-[55px] mt-[5px]
		                	max-md:mt-[10px] max-md:min-h-[auto]">
		                	Find articles, videos, and more resources about how YourReview works.
		                </p>
		                <Link className="primary-link with-arrow !mt-[10px] pr-[80px] !underline
		                	max-md:!text-base max-md:pr-0" href="/#">
			                Go to help Center
			            </Link>
		            </div>
		            <div className="quick-card card--3 p-[35px_40px_48px_49px] bg-white rounded-[24px] 
		            	max-md:p-[35px_35px_44px_35px]">
		                <h6 className="text-[#000] text-xl font-bold !leading-[1.51] mb-[10px]">Press site</h6>
		                <p className="text-left text-[#808080] text-base font-medium !leading-[1.50] min-h-[55px] mt-[5px]
		                	max-md:mt-[10px] max-md:min-h-[auto]">
		                	For editiorial, media, and press inquiries.
		                </p>
		                <Link className="primary-link with-arrow !mt-[10px] pr-[80px] !underline
		                	max-md:!text-base max-md:pr-0" href="/#">
			                Go to Press site
			            </Link>
		            </div>
		            <div className="quick-card card--4 p-[35px_40px_48px_49px] bg-white rounded-[24px] 
		            	max-md:p-[35px_35px_44px_35px]">
		                <h6 className="text-[#000] text-xl font-bold !leading-[1.51] mb-[10px]">Sales and pricing</h6>
		                <p className="text-left text-[#808080] text-base font-medium !leading-[1.50] min-h-[55px] mt-[5px]
		                	max-md:mt-[10px] max-md:min-h-[auto]">
		                	Ask about our plans, upgrades, services, and more.
		                </p>
		                <Link className="primary-link with-arrow !mt-[10px] pr-[80px] !underline
		                	max-md:!text-base max-md:pr-0" href="/#">
			                Contact Sales
			            </Link>
		            </div>
		            <div className="quick-card card--5 p-[35px_40px_48px_49px] bg-white rounded-[24px] 
		            	max-md:p-[35px_35px_44px_35px]">
		                <h6 className="text-[#000] text-xl font-bold !leading-[1.51] mb-[10px]">Submit a request</h6>
		                <p className="text-left text-[#808080] text-base font-medium !leading-[1.50] min-h-[55px] mt-[5px]
		                	max-md:mt-[10px] max-md:min-h-[auto]">
		                	Need help? We’ll get back to you as soon as possible.
		                </p>
		                <Link className="primary-link with-arrow !mt-[10px] pr-[80px] !underline
		                	max-md:!text-base max-md:pr-0" href="/#">
			                Submit Request
			            </Link>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}