	import Image from 'next/image'
	import Link from 'next/link'

	export default function CheckReviews(){
		return(
			<>
			<section className="check-reviews max-l:py-[50px] max-xl:py-[60px] max-xxl:py-[70px] py-[80px] bg-white relative">
				<div className="container mx-auto px-4">
					<div className="check-reviews-content max-xl:text-center">
						<div className="row flex flex-wrap -mx-6">
							<div className="w-full lg:w-1/2 px-6">
								<div className="image--area block max-xl:mx-auto max-xl:!pb-[40px] max-w-[568px]">
									<Image 
										src="/images/consumers-check-reviews-img.svg" alt="consumers-check-reviews"
										width={568} 
										height={391}
										className="w-full  max-w-full"
									/>
								</div>
							</div>

							<div className="w-full lg:w-1/2 px-6">
								<div className="text--area">
									<h2 className="mb-[10px] font-bold leading-[1.17]">90% of Consumers Check Reviews Prior to Purchasing.</h2>
									<p className="text-[#7c7c7c] mb-[44px] text-lg font-medium leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. has been the
										industry's standard dummy text </p>
										<Link className="ms-btn primary-solid btn-xl max-l:!text-[16px] max-l:!py-[22px] max-l:!px-[30px]" href="/#">Explore the Data</Link>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
				</>
				);
	}