'use client';

import Image from 'next/image'

import { useEffect, useRef, useState } from 'react'

export default function VideoSection() {
  const videoRef = useRef<HTMLVideoElement>(null);
  const [isPlaying, setIsPlaying] = useState(false)
  const [showPause, setShowPause] = useState(false)

  const togglePlay = () => {
    const video = videoRef.current;
    if (!video) return;
    if (video.paused) {
      video.play()
      setIsPlaying(true)
    } else {
      video.pause()
      setIsPlaying(false)
    }
  }

  useEffect(() => {
    const video = videoRef.current
    const handleEnded = () => setIsPlaying(false)

    if (!video) return;
    video.addEventListener('ended', handleEnded);
    if (!video) return;
    return () => video.removeEventListener('ended', handleEnded);
  }, [])

  return (
    <div
      className="video-data"
      onMouseEnter={() => { if (isPlaying) setShowPause(true) }}
      onMouseLeave={() => setShowPause(false)}
    >
      <video
        ref={videoRef}
        poster="/images/sample-review-tumb.jpg"
        className="w-full rounded-lg"
      >
        <source src="/images/sample-review.mp4" type="video/mp4" />
      </video>

      <button
        onClick={togglePlay}
        className="absolute inset-0 flex justify-center items-center"
      >
        {!isPlaying && (
          <span className="video-control-play">
            <Image 
              src="/images/button-play.svg" alt="Play" 
              width={86}
              height={86}
              className="w-full h-full"
            />
          </span>
        )}
        {isPlaying && showPause && (
          <span className="video-control-pause">
            <img 
              src="/images/button-pause.svg" alt="Pause" 
              width={86}
              height={86}
              className="w-full h-full"
            />
          </span>
        )}
      </button>
    </div>
  )
}
