import Link from 'next/link';
import MobileHeader from './MobileHeader'

const HomeHeader = () => {
  return (
    <>
    <header className="HomeHeader without-bg w-full">
        <section className="main-menu">
          <ul className="menulist-left">
              <li><Link href="/pricing" className="text-[#323232] hover:text-[#713fff]">Plans</Link></li>
              <li><Link href="/customer-stories" className="text-[#323232] hover:text-[#713fff]">Reviews</Link></li>
              <li><Link href="/webinars" className="text-[#323232] hover:text-[#713fff]">Resources</Link></li>
              <li><Link href="/our-story" className="text-[#323232] hover:text-[#713fff]">About</Link></li>
          </ul>
          <ul className="menulist-right">
              <li><Link href="/customer-register-login" className="text-[#323232] hover:text-[#713fff]">Join</Link></li>
              <li><Link href="/business-registration-login" className="text-[#323232] hover:text-[#713fff]">Sign in</Link></li>
              <li><Link className="ms-btn primary-solid btn-sm hover:bg-[#713fffcc]" href="/business-registration-login">Business</Link></li>
          </ul>
      </section>
    </header>
    <MobileHeader />
    </>
  );
};

export default HomeHeader;
