import Link from 'next/link'

export default function VectorArticleBlock(){
	return(
		<>
		<section className="vector-article-block pb-[130px] mt-[-145px]">
		    <div className="container mx-auto px-4">
		        <div className="row flex flex-wrap -mx-3 -mt-6">
		            <div className="max-l:w-full w-1/2 px-3 mt-6">
		                <div className="vector-article-block-content content-center text-center h-full bg-white 
		                	max-xl:p-[38px] p-[53px] rounded-[29px]">
		                    <figure className="max-xl:mb-[50px] mb-[100px] flex justify-center items-center">
		                        <img src="images/be-discovered.svg" alt=""
		                        	 className="max-w-[470px] max-h-[288px] w-full lg:h-[288px]"
		                        />
		                    </figure>
		                    <div className="heading-content">
		                        <span className="heading-label block text-[#713fff] mb-[13px] max-md:text-base text-lg font-semibold leading-[1.40]
		                        	uppercase">
		                        	Categories</span>
		                        <h2 className="llg:text-[48px] font-nunito font-bold leading-[1.20] text-[#323232] mb-[24px]
		                        	">Be discovered</h2>
		                        <p className="max-w-[468px] max-sm:text-sm max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-lg mx-auto text-center font-normal text-[#6d6d6d] leading-[1.58]">
		                            Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. 
		                            Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, 
		                            when an unknown printer took a galley of type and scrambled it to make a type specimen book.
		                        </p>
		                    </div>
		                </div>
		            </div>
		            <div className="max-l:w-full w-1/2 px-3 mt-6">
		                <div className="vector-article-block-content content-center text-center h-full bg-white 
		                	max-xl:p-[38px] p-[53px] rounded-[29px]">
		                    <figure className="max-xl:mb-[50px] mb-[100px] flex justify-center items-center">
		                        <img src="images/build-trust-with-transparency.svg" alt=""
		                        	 className="max-w-[470px]  w-full h-[340px]"
		                        />
		                    </figure>
		                    <div className="heading-content">
		                        <span className="heading-label block text-[#713fff] mb-[13px] max-md:text-base text-lg font-semibold leading-[1.40]
		                        	uppercase">Business Transparency</span>
		                        <h2 className="llg:text-[48px] font-nunito font-bold leading-[1.20] text-[#323232] mb-[24px]
		                        	">Build trust with transparency</h2>
		                        <p className="max-w-[468px] max-sm:text-sm max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-lg mx-auto text-center font-normal text-[#6d6d6d] leading-[1.58]">
		                            Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                            the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
		                            of type and scrambled it to make a type specimen book.
		                        </p>
		                    </div>
		                </div>
		            </div>
		        </div>

		        <div className="article-block review-nvitations max-md:py-[30px] max-md:px-[20px] p-[42px_54px_65px_54px] mt-[24px] flex items-center
		        	bg-white border-none rounded-[29px] max-l:text-center">
		            <div className="row flex flex-wrap -mx-3">
		                <div className="w-full lg:w-7/12 px-3">
		                    <div className="article-block--content py-[30px] mt-[30px]">
		                        <span className="heading-label block text-[#713fff] mb-[13px] max-md:text-base text-lg font-semibold leading-[1.40]
		                        	uppercase">Review Invitations</span>
		                        <h2 className="mb-[15px]">All you have to do is ask</h2>
		                        <p className="max-w-[610px] text-[#6d6d6d] max-sm:text-sm max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-lg font-normal leading-[1.58]">
		                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.
		                        </p>
		                        <Link className="primary-link with-arrow max-md:!text-base llg:!text-xl max-md:!p-0 pr-[80px] !underline
		                        	!mt-[32px]" href="">Know more about </Link>
		                    </div>
		                </div>
		                <div className="w-full lg:w-5/12 px-3">
		                    <figure className="article-block--image w-auto text-center">
		                        <img src="images/vector-review-invitations.svg" alt=""
		                        	className="w-[485px] max-w-full max-l:mx-auto"
		                        />
		                    </figure>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}