'use client';

import React, { useState } from 'react';
import Select, { SingleValue, StylesConfig } from 'react-select';

interface OptionType {
  value: string;
  label: string;
}

const partnerOptions: OptionType[] = [
  { value: ' ', label: 'Partner Type' },
  { value: 'reseller', label: 'Reseller' },
  { value: 'vendor', label: 'Vendor' },
];

const countryOptions: OptionType[] = [
  { value: 'india', label: 'India' },
  { value: 'usa', label: 'USA' },
];

const customStyles: StylesConfig<OptionType, false> = {
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#8794a4',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? '700' : '400',
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    color: '#8794a4',
    fontWeight: 400,
    fontSize: 16,
    padding: '7px',
    border: '1px solid #dad6e5',
    borderRadius: 5,
    backgroundColor: '#fefefe',
    boxShadow: state.isFocused ? '0 0 0 1px #e8e8e8' : 'none',
    '&:hover': {
      borderColor: '#e8e8e8',
    },
  }),
  singleValue: (base) => ({
    ...base,
    maxWidth: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    color: '#8794a4',
    marginLeft: '2px',
    marginRight: '2px',
    fontWeight: 400,
    textAlign: 'left',
    // Responsive font size
  '@media (max-width: 991px)': {
    fontSize: '15px !important',
  },
  }),
  dropdownIndicator: (base, state) => ({
        ...base,
        color: '#8794a4',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#8794a4',
          stroke: '#8794a4',
          strokeWidth: 0,
      },
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
};

export default function ContactSaleForm() {
  const [selectedPartner, setSelectedPartner] = useState<OptionType>(partnerOptions[0]);

  const handlePartnerChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedPartner(option);
  };

  const [selectedCountry, setSelectedCountry] = useState<OptionType>(countryOptions[0]);

  const handleCountryChange = (option: SingleValue<OptionType>) => {
    if (option) setSelectedCountry(option);
  };

  return (
    <section className="partners-banner contact-sale-form pb-[80px] bg-[#f5f5f5] relative">
      <div className="container mx-auto px-4">
        
          <div className="become-partner-form max-l:p-[30px_15px_30px_15px] p-[86px_86px_80px_86px] max-w-[858px] 
            mx-auto bg-white rounded-[22px] relative z-[1]">
            <form className="grid max-sm:grid-cols-1 grid-cols-2 gap-y-[15px] gap-x-[12px]">
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="First name" />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]"
                  type="text" placeholder="Last name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="email" placeholder="Business Email" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Company Name" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <Select
                  options={partnerOptions}
                  value={selectedPartner}
                  onChange={handlePartnerChange}
                  classNamePrefix="react-select"
                  placeholder="Partner Type"
                  styles={customStyles}
                />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="url" placeholder="Website URL" />
              </div>
              <div className="form-field">
                <Select
                  options={countryOptions}
                  value={selectedCountry}
                  onChange={handleCountryChange}
                  classNamePrefix="react-select"
                  placeholder="Country"
                  styles={customStyles}
                />
              </div>
              <div className="form-field">
                <input className="textbox rounded-[5px] border border-[#dad6e5] bg-[#fefefe] text-[#8794a4] font-normal 
                  w-full py-[15px] px-[18px] min-h-[50px] max-l:text-[15px] text-[16px]" 
                  type="text" placeholder="Phone number" />
              </div>
              <div className="form-field full--width sm:col-span-2">
                <button type="submit" className="ms-btn primary-solid btn-md w-full !block !mt-[5px] 
                   !py-[24px] !px-[55px] !text-[20px] max-l:!py-[22px] max-l:!px-[30px] max-l:!text-[16px] ">
                  Send Message
                </button>
              </div>
            </form>
          </div>

          <span className="note block max-w-[700px] text-[12px] text-[#808080] text-center mx-auto pt-[30px]">
            By clicking above you accept our privacy policy and agree to receive emails or 
            calls from YourReview about our products and services. You may unsubscribe at any time by 
            clicking the unsubscribe link at the bottom of the email or by contacting us at privacy@yourreviewt.Com. 
            YourReviews calls may be recorded for training and quality purposes.
          </span>
        </div>
    </section>
  );
}
