'use client';

import { useState } from 'react';
import PhoneInput from './PhoneInput';
import Select, {
  GroupBase,
  StylesConfig,
} from 'react-select';

interface OptionType {
  value: string;
  label: string;
}

const countryOptions: OptionType[] = [
  { value: 'India', label: 'India' },
  { value: 'USA', label: 'USA' },
];

const categoryOptions: GroupBase<OptionType>[] = [
  {
    label: 'Animals & Pets',
    options: [
      { value: 'Animal Health', label: 'Animal Health' },
      { value: 'Animal Parks & Zoos', label: 'Animal Parks & Zoos' },
      { value: 'Cats & Dogs', label: 'Cats & Dogs' },
    ],
  },
  {
    label: 'Beauty & Well-being',
    options: [
      { value: 'Cosmetics', label: 'Cosmetics' },
      { value: 'Hair Care', label: 'Hair Care' },
      { value: 'Personal Care', label: 'Personal Care' },
      { value: 'Salons & Clinics', label: 'Salons & Clinics' },
    ],
  },
];

const customStyles: StylesConfig<OptionType, false, GroupBase<OptionType>> = {
  groupHeading: (base) => ({
    ...base,
    color: '#424242',
    backgroundColor: '#f3f3f3',
    padding: '20px',
    fontSize: '16px',
    fontWeight: 600,
  }),
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected || state.isFocused ? '#f6f6f6' : 'white',
    color: '#949eaa',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? 600 : 400,
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    fontSize: 16,
    padding: 8,
    border: '1px solid #d6d6d6',
    borderRadius: 5,
    backgroundColor: 'transparent',
    boxShadow: state.isFocused ? '0 0 0 1px #d6d6d6' : 'none',
    '&:hover': { borderColor: '#d6d6d6' },
  }),
  singleValue: (base) => ({
    ...base,
    color: '#8794a4',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    fontSize: '16px',
    fontWeight: 400,
  }),
  dropdownIndicator: (base) => ({
    ...base,
    color: '#999',
    svg: {
      fill: '#999',
      stroke: '#999',
      strokeWidth: 0,
    },
  }),
  menu: (base) => ({
    ...base,
    borderRadius: 6,
    padding: 4,
    boxShadow: '0 2px 8px rgba(0,0,0,0.15)',
  }),
  indicatorSeparator: () => ({ display: 'none' }),
};

export default function BusinessAccountForm() {
  const [selectedCountry, setSelectedCountry] = useState<OptionType | null>(null);
  const [selectedCategory, setSelectedCategory] = useState<OptionType | null>(null);
  const [selectedCategoryProductForm, setSelectedCategoryProductForm] = useState<OptionType | null>(null);
  const [activeTab, setActiveTab] = useState<'business' | 'product'>('business');


  return (
    <>
      <section className="business-account-form bg-[#f5f5f5] pb-[72px] relative">
      <div className="container mx-auto px-4">
        <div className="form-holder mx-auto max-w-[1124px] bg-white shadow-md rounded-[22px] max-sm:py-10 max-sm:px-[15px] 
          max-md:py-10 max-md:px-10 py-[70px] px-[80px] relative">
          <div className="signup-with-email">
            <div className="primary-tabs flex w-max mx-auto px-[5px] py-[4px] justify-center outline outline-[1px] outline-[rgba(113,63,255,0.3)] shadow-[0px_0px_20px_10px_rgba(113,63,255,0.05)] rounded-full overflow-hidden relative">

              <button
                className={`primary-tab max-xl:text-[15px] max-480:text-[12px] max-480:px-[5px] max-xl:py-[15px] px-[35px] py-[20px] text-[18px] font-medium rounded-[50px] border ${
                  activeTab === 'business'
                  ? 'bg-[#713fff] text-white'
                  : 'border-transparent text-[#03020280]'
                }`}
                onClick={() => setActiveTab('business')}
              >
                Business Registration
              </button>
              <button
                className={`primary-tab max-xl:text-[15px] max-480:text-[12px] max-480:px-[5px] max-xl:py-[15px] max-xl:px-5 px-[35px] py-[20px] text-[18px] font-medium rounded-[50px]  border ${
                  activeTab === 'product'
                  ? 'bg-[#713fff] text-white'
                  : 'border-transparent text-[#03020280]'
                }`}
                onClick={() => setActiveTab('product')}
              >
                Product Registration
              </button>
            </div>
            <div className="primary-tab-content mt-[60px]">
              {activeTab === 'business' && (
                <div className="businessRegistrationTab">
                  <div className="max-w-7xl mx-auto">
                    <form className="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        {/* Row 1 */}
                      <div>
                        <input type="text" placeholder="Company Name" name="companyName" className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]" />
                      </div>
                      <div>
                        <input type="email" placeholder="Email ID" name="companyEmail" className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]" />
                      </div>

                        {/* Row 2 */}
                      <div>
                        <PhoneInput />
                      </div>
                      <div>
                        <input type="text" placeholder="Website" name="companyWebsite" className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]" />
                      </div>

                        {/* Row 3 - Address */}
                      <div className="lg:col-span-2">
                        <textarea placeholder="Address" name="companyAddress" className="w-full min-h-[100px] font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"></textarea>
                      </div>

                        {/* Row 4 - About Company */}
                      <div className="lg:col-span-2">
                        <textarea placeholder="About Company" name="aboutCompany" className="w-full min-h-[100px] font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"></textarea>
                      </div>

                        {/* Row 5 - Location + PIN + Country */}
                      <div className="lg:col-span-2 grid grid-cols-12 gap-6">
                            {/* Location - 50% */}
                        <div className="col-span-12 lg:col-span-6">
                          <input
                            type="text"
                            name="location"
                            placeholder="Location"
                            className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"
                          />
                        </div>

                            {/* PIN - 25% */}
                        <div className="col-span-12 lg:col-span-3">
                          <input
                            type="text"
                            name="pin"
                            placeholder="PIN"
                            className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"
                          />
                        </div>

                            {/* Country - 25% */}
                        <div className="col-span-12 lg:col-span-3">
                          <Select name="businessCountry" options={countryOptions} value={selectedCountry} onChange={setSelectedCountry} 
                            placeholder="Select Country" isClearable className="" styles={customStyles} />
                          </div>
                        </div>


                        {/* Row 6 - Category + File Upload */}
                        <div>
                          <Select name="businessCategory" options={categoryOptions} value={selectedCategory} onChange={setSelectedCategory} 
                            placeholder="Select Category" isClearable className="" styles={customStyles} />
                          </div>
                          <div className="flex items-center gap-x-2">
                            <label htmlFor="product-files" className="text-sm font-medium min-w-[150px]"> Upload Business Files: </label>
                            <input type="file" id="business-files" name="businessFiles" multiple accept="image/*,application/pdf" 
                              className="block w-full text-base text-[#8794a4] file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:font-semibold file:bg-[#713fff] file:text-white hover:file:bg-[#713fff]" />
                            </div>

                        {/* Checkbox */}
                            <div className="lg:col-span-2 flex items-center space-x-3">
                              <input type="checkbox" name="agreeToBusinessDemo" id="signup-agreed" className="form-check-input w-[19px] h-[19px]  text-[#3f97ff] bg-[#fafafa] border border-[#3f97ff] rounded-[4px]" />
                              <label htmlFor="signup-agreed" className="form-check-label text-base font-normal text-[#323232]">I'd like to receive a demo of YourReviews's paid plans.</label>
                            </div>

                        {/* Submit */}
                            <div className="lg:col-span-2 text-center mt-3">
                              <button type="submit" className="w-full inline-block min-w-[130px] max-w-[527px] font-semibold block 
                                bg-[#713fff] text-white max-l:text-base max-xl:py-[22px] max-xl:px-[30px] text-xl py-6 px-14 rounded-[49px] hover:bg-[#713fffcc] transition">
                                Create free account</button>
                              </div>

                        {/* Note */}
                              <div className="note lg:col-span-2 text-sm font-normal text-center text-[#323232] mt-3">
                                This site is protected by reCAPTCHA and the Google 
                                <a href="#" className="underline text-[#713fff]">Privacy Policy</a> and 
                                <a href="#" className="underline text-[#713fff]">Terms of Service</a> apply.
                              </div>
                            </form>

                          </div>
                        </div>
                        )}
{activeTab === 'product' && (
  <div className="productRegistrationTab">
    <div className="max-w-7xl mx-auto">
      <form className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div>
          <input type="text" name="productName" placeholder="Product Name" className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]" />
        </div>
        <div>
          <input type="text" name="websiteEmail" placeholder="Website Email" className="w-full font-normal text-base text-[#8794a4] bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]" />
        </div>
        <div className="lg:col-span-2">
          <textarea name="productDescription" placeholder="Product Description" className="w-full font-normal text-base text-[#8794a4] 
            bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"></textarea>
          </div>
          <div className="lg:col-span-2">
            <textarea name="aboutProduct" placeholder="About Product" className="w-full font-normal text-base text-[#8794a4] 
              bg-[#fefefe] border border-[#dad6e5] rounded-[5px] px-[18px] py-[15px]"></textarea>
            </div>
            <div>
              <Select name="prodctCategory" options={categoryOptions} value={selectedCategoryProductForm} onChange={setSelectedCategoryProductForm} 
                placeholder="Select Category" isClearable className="" styles={customStyles} />
              </div>
              <div className="flex items-center gap-x-2">
                <label htmlFor="product-files" className="text-sm font-medium min-w-[150px]"> Upload Product Files: </label>
                <input type="file" id="product-files" name="productFiles" multiple accept="image/*,application/pdf" 
                  className="block w-full text-base text-[#8794a4] file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:font-semibold file:bg-[#713fff] file:text-white hover:file:bg-[#713fff]" />
                </div>

                    {/* Checkbox */}
                <div className="lg:col-span-2 flex items-center space-x-3">
                  <input type="checkbox" name="agreeToProductDemo" id="signup-agreed" className="form-check-input w-[19px] h-[19px]  text-[#3f97ff] bg-[#fafafa] border border-[#3f97ff] rounded-[4px]" />
                  <label htmlFor="signup-agreed" className="form-check-label text-base font-normal text-[#323232]">I'd like to receive a demo of YourReviews's paid plans.</label>
                </div>
                <div className="lg:col-span-2 text-center mt-3">
                  <button type="submit" className="w-full inline-block min-w-[130px] max-w-[527px] font-semibold block 
                    bg-[#713fff] text-white text-xl py-6 px-14 rounded-[49px] hover:bg-[#713fffcc] transition">
                    Create free account</button>
                  </div>

                    {/* Note */}
                  <div className="note lg:col-span-2 text-sm font-normal text-center text-[#323232] mt-3">
                    This site is protected by reCAPTCHA and the Google 
                    <a href="#" className="underline text-[#713fff]">Privacy Policy</a> and 
                    <a href="#" className="underline text-[#713fff]">Terms of Service</a> apply.
                  </div>
                </form>
              </div>
            </div>
            )}
</div>
</div>
</div>
</div>
</section>
</>
  );
}
