type Rating = {
  stars: number;
  percent: number;
};

interface Props {
  ratings: Rating[];
}
  export default function RatingProgressBar ({ ratings }: Props){
    return (
      <div className="rating-overview--right max-md:w-full max-xxl:w-[40%] w-1/2">
        <div className="progress_bar w-full">
          {ratings.map((rating, index) => (
            <div
              key={index}
              className="progress_bar_item relative p-[11px_11px_11px_45px]"
            >
              <input
                type="checkbox"
                className="form-check-input absolute left-0 !mt-[4px] w-[28px] h-[28px] rounded-[4px] 
                appearance-none border border-[#d1cddf] bg-[#efedf5] 
                checked:bg-[#713fff] checked:border-[#713fff] 
                transition duration-150 ease-in-out"
              />
              <div className="item_label text-[#737373] text-sm font-normal leading-[1.07]">
                {rating.stars}-star
              </div>
              <div className="progress_line flex items-center gap-[15px]">
                <div className="item_bar relative h-[8px] w-full bg-[#e8e2fa] rounded-[4px]">
                  <div
                    className="progress absolute left-0 top-0 h-full bg-[#713fff] rounded-[4px]"
                    style={{ width: `${rating.percent}%` }}
                  ></div>
                  </div>
                  <div className="item_value text-[#737373] text-sm font-normal leading-[1.07]">{rating.percent}%</div>
                </div>
              </div>
              ))}
        </div>
      </div>
      );
  }
