import Link from 'next/link'

export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner agency-partner-banner text-center max-sm:pb-[50px] max-md:pb-[60px] 
			max-xl:pb-[80px] pt-[140px] pb-[108px]">
			<div className="container mx-auto px-4 text-center">
				<div className="content--area max-w-[678px] mx-auto">

					<h1 className="font-extrabold max-sm:max-w-[320px] max-sm:mx-auto max-sm:text-[36px] 
						max-xl:text-[54px] max-md:!leading-[1.10] !leading-[1.08]">
						Find and Connect with a Service Partner
					</h1>
					<p className="text-[#343434] text-center font-inter max-md:text-base text-xl font-semibold !leading-[147%] mt-[15px]">
						Compare the best product in this category
					</p>

					<form action="/#" name="search-form">
						<div className="site-search !mt-[42px]">
							<input
								type="text"
								placeholder="Search a Business or product Name"
								className="form-control max-md:!leading-[55px] max-md:!text-[14px] max-md:!px-[20px]  
								placeholder-gray-400"
							/>
							<Link href="/#" className="absolute right-[13px] top-1/2 -translate-y-1/2 
								flex items-center justify-center gap-x-1.5 rounded-full bg-[#713fff] 
								text-white font-bold backdrop-blur-sm w-12 h-12 p-0 min-w-0 md:w-auto 
								md:h-auto md:px-[27px] md:leading-[43px] md:min-w-[130px] md:text-[14px] max-md:right-[8px] 
								hover:bg-[#323232]"> 
							<i className="icon-search max-md:mr-0 mr-[2px]"></i><span className="hidden md:inline">Search</span></Link>
						</div>
					</form>
				</div>
			</div>
		</section>
		</>
		);
}