import Image from 'next/image'
import Link from 'next/link'

export default function ImageArticleBlock(){
	return(
		<>
		<section className="image-article-block agency-partners pt-[90px] pb-[75px] bg-[#f5f5f5]
			max-3xl:py-[80px] max-xxl:py-[70px] max-xl:py-[60px] max-l:py-[50px]">
		    <div className="container mx-auto px-4">
		        <div className="image-article-block-content flex justify-between gap-[30px]
		        	max-l:flex-col max-l:gap-[22px]">
		            <figure className="flex-shrink-0 max-l:w-full">
		                <Image src="/images/locate-and-engage.png" alt=""
		                	width={566}
		                	height={546}
		                	className="block max-w-full max-l:mx-auto"
		                />
		            </figure>
		            <div className="text-area max-w-[590px] mx-auto p-0 max-l:text-center">
		                <h2 className="max-l:mb-[13px] mb-[23px] text-[#323232]">Locate and Engage with a Service Partner</h2>
		                <p className="text-[#808080] mb-[30px] max-sm:text-[14px] max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] 
		                	text-lg font-normal !leading-[1.43] tracking-[-0.1px]">
		                	Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                    the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
		                    of type and scrambled it to make a type specimen book.
		                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                    the industry's.</p>
		                <p className="text-[#808080] mb-[30px] max-sm:text-[14px] max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] 
		                	text-lg font-normal !leading-[1.43] tracking-[-0.1px]">
		                	Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                    the industry's standard dummy text ever since the 1500s,</p>
		                <Link className="ms-btn primary-solid btn-xl max-xl:!text-[17px]
		                	max-l:!py-[22px] max-l:!px-[30px] max-l:!text-[16px]" href="/#">Get matched with a partner
		                </Link>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}