'use client';

import React, { useState } from 'react';
import Select, { StylesConfig } from 'react-select';
import Link from 'next/link'

interface OptionType {
  value: string;
  label: string;
}

const customStyles: StylesConfig<OptionType, false> = {
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected
      ? '#f3f3f3'
      : state.isFocused
      ? '#f6f6f6'
      : 'white',
    color: '#969696',
    padding: 10,
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: state.isSelected ? '700' : '400',
  }),
  control: (base, state) => ({
    ...base,
    width: '100%',
    color: '#969696',
    fontWeight: 400,
    fontSize: 16,
    padding: '4px',
    border: '1px solid #e8e8e8',
    borderRadius: 5,
    backgroundColor: 'white',
    boxShadow: state.isFocused ? '0 0 0 1px #e8e8e8' : 'none',
    '&:hover': {
      borderColor: '#e8e8e8',
    },
  }),
  singleValue: (base) => ({
    ...base,
    maxWidth: '100%',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    color: '#969696',
    marginLeft: '2px',
    marginRight: '2px',
    fontWeight: 400,
  }),
  dropdownIndicator: (base, state) => ({
        ...base,
        color: '#9e96b2',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#9e96b2',
          stroke: '#9e96b2',
          strokeWidth: 0,
      },
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
};

// Options per select
const ecommerceOptions = [
  { value: 'shopify', label: 'Shopify' },
  { value: 'woocommerce', label: 'WooCommerce' },
  { value: 'magento', label: 'Magento' },
];

const specialismOptions = [
  { value: 'seo', label: 'SEO' },
  { value: 'development', label: 'Development' },
  { value: 'marketing', label: 'Marketing' },
];

const languageOptions = [
  { value: 'english', label: 'English' },
  { value: 'french', label: 'French' },
  { value: 'spanish', label: 'Spanish' },
];

const locationOptions = [
  { value: 'usa', label: 'USA' },
  { value: 'uk', label: 'UK' },
  { value: 'india', label: 'India' },
];

export default function AgencyPartnersList(){
	const [searchText, setSearchText] = useState('');
  const [platform, setPlatform] = useState(ecommerceOptions[0]);
  const [specialism, setSpecialism] = useState(specialismOptions[0]);
  const [language, setLanguage] = useState(languageOptions[0]);
  const [location, setLocation] = useState(locationOptions[0]);

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    const formData = {
      search: searchText,
      platform: platform.value,
      specialism: specialism.value,
      language: language.value,
      location: location.value,
    };

    // You can log or send this data to an API
    console.log('Form submitted:', formData);
  };

	return(
		<>
		<section className="agency-partners-list bg-[#eaeef4] max-l:py-[50px] max-xl:py-[60px] max-xxl:py-[80px] 
			max-3xl:py-[105px] pt-[80px] pb-[40px]">
		    <div className="container mx-auto px-4">
		        <div className="row flex flex-wrap -mx-3">
		            <div className="w-full llg:w-1/4 px-3">

		                <div className="side-box combin-box p-0 mb-[32px] rounded-[20px] bg-[#e4e8ef]">
		                    <div className="content--area p-[38px_23px_28px_23px]">
                                <form className="form" onSubmit={handleSubmit}>
							      <h6 className="mt-[12px] mb-[6px] text-[#000000] text-base font-semibold !leading-[1.58]">
							      	Search
							      </h6>
							      <div className="form-field relative">
							        <input
							          type="text"
							          placeholder="Search"
							          value={searchText}
							          onChange={(e) => setSearchText(e.target.value)}
							          className="w-full px-[15px] h-[45px] rounded-[4px] border-none bg-white 
							          text-[#969696] text-[16px] font-normal leading-[45px]"
							        />
							        <i className="icon-search absolute text-[16px] text-[#9e96b2] 
							        	right-[15px] top-1/2 -translate-y-1/2" />
							      </div>

							      <h6 className="mt-[12px] mb-[6px] text-[#000000] text-base font-semibold !leading-[1.58]">
							      	eCommerce Platform
							      </h6>
							      <Select
							        options={ecommerceOptions}
							        styles={customStyles}
							        value={platform}
							        onChange={(option) => setPlatform(option!)}
							      />

							      <h6 className="mt-[12px] mb-[6px] text-[#000000] text-base font-semibold !leading-[1.58]">
							      	Specialism
							      </h6>
							      <Select
							        options={specialismOptions}
							        styles={customStyles}
							        value={specialism}
							        onChange={(option) => setSpecialism(option!)}
							      />

							      <h6 className="mt-[12px] mb-[6px] text-[#000000] text-base font-semibold !leading-[1.58]">
							      	Language
							      </h6>
							      <Select
							        options={languageOptions}
							        styles={customStyles}
							        value={language}
							        onChange={(option) => setLanguage(option!)}
							      />

							      <h6 className="mt-[12px] mb-[6px] text-[#000000] text-base font-semibold !leading-[1.58]">
							      	Locations served
							      </h6>
							      <Select
							        options={locationOptions}
							        styles={customStyles}
							        value={location}
							        onChange={(option) => setLocation(option!)}
							      />
							    </form>
		                    </div>

		                    <div className="text--area rounded-[0px_0px_20px_20px] p-[34px_23px_38px_23px] bg-[#ffffff70]">
		                        <h6 className="mb-[4px] text-[#000000] text-base font-semibold !leading-[1.58]">
		                        	Let us match you
		                        </h6>
		                        <p className="text-[#6d6d6d] text-sm font-normal !leading-[1.58]">
		                        	Lorem Ipsum is simply dummy text of the printing 
		                        </p>
		                    
		                        <div className="note flex mt-[20px] gap-y-[8px] gap-x-[25px]">
		                            <span className="block text-[#6d6d6d] text-[12px] font-normal !leading-[1.24]">
		                            	Meet YourReview, your service partner matchmaker</span>
		                            <img src="images/chat--icon.svg" alt="Icon"
		                            	className="block flex-shrink-0 w-[35px] h-[35px]"
		                            />
		                        </div>
		                        <Link className="ms-btn primary-solid !block mt-[20px] max-l:!text-[18px]
		                        	max-l:!py-[16px] max-l:!px-[40px]" href="/#">Get Matched </Link>
		                    </div>
		                </div>
		            </div>

		            <div className="w-full llg:w-3/4 px-3">
		                <div className="agency-partners-list-content grid max-xl:grid-cols-2 grid-cols-3 justify-items-center 
		                	gap-[25px]">
		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Premier Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Medallia</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/medallia-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Premier Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">RedEye</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/redd-eye-icon.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">emarsys</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/emarsys-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                        	<i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Sprinklr</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/sprinklr-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Premier Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Dotdigital</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/dotdigital-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Bigcommerce</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/big-commerce-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Premier Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Williams Commerce</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/williams-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#6d6d6d]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Premier Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">PushON</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/push-on-icon.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Fluid Commerce</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/fluid-icon.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Velstar</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/velstar-icon.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been
		                            the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">Sprinklr</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/sprinklr-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>


		                    <div className="partners-card flex flex-col items-center max-w-[305px] w-full
		            	text-center p-[28px] rounded-[20px] bg-white active">
		                        <figure className="star-icon w-[24px] h-[24px] mb-[12px]">
		                            <i className="icon-star text-[25px] text-[#713fff]"></i>
		                        </figure>
		                        <span className="block mb-[12px] text-[#713fff] text-sm font-normal !leading-[1.07] uppercase">Pro Partner</span>
		                        <h4 className="mb-[30px] text-[#343434] text-[20px] font-bold !leading-[1.07]">dotdigital</h4>
		                        <figure className="partner-logo w-full mb-[18px]">
		                            <img src="images/dotdigital-logo.png" alt="Logo" className="max-w-full"/>
		                        </figure>
		                        <p className="text-[#6d6d6d] text-center text-base font-normal !leading-[1.58]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
		                            has been the industry's standard dummy text...</p>
		                    </div>
		                </div>
		                <div className="cta max-l:mt-[35px] mt-[55px] text-center">
		                    <Link className="btn-md max-l:!text-[15px] !text-[16px] max-l:!py-[16px] !py-[14px] !px-[35px] !font-semibold 
		                    	!text-[#3e3e3e] !rounded-[5px] !border !border-[#26323866] relative inline-block
		                    	text-center overflow-hidden" href="/#">
		                    	Load More</Link>
		                </div>
		            </div>
		        </div>

		    </div>
		</section>
		</>
		);
}