// app/layout.tsx
import './global.css';
import '../public/fonts/icomoon/style.css'
import { Inter, Nunito } from 'next/font/google';
import { ReactNode } from 'react';
import Header from '../components/Header/Header';
import Footer from '../components/Footer/Footer';

const inter = Inter({
  subsets: ['latin'],
  variable: '--font-inter',
  weight: ['400', '500', '600', '700', '800'],
  display: 'swap',
});

const nunito = Nunito({
  subsets: ['latin'],
  variable: '--font-nunito',
  weight: ['400', '500', '600', '700', '800'],
  display: 'swap',
});

export const metadata = {
  title: 'Your Reviews',
  description: 'Make Smarter Choices with Your Reviews',
  icons: {
    icon: '/images/favicon.png',
  },
};

export default function RootLayout({ children }: { children: ReactNode }) {
  return (
    <html lang="en" className={`${inter.variable} ${nunito.variable} font-nunito`}>
      <body>
          <Header />
          {children}
          <Footer />
      </body>
    </html>
  );
}
