// const { createGlobPatternsForDependencies } = require('@nx/next/tailwind');

// The above utility import will not work if you are using Next.js' --turbo.
// Instead you will have to manually add the dependent paths to be included.
// For example
// ../libs/buttons/**/*.{ts,tsx,js,jsx,html}',                 <--- Adding a shared lib
// !../libs/buttons/**/*.{stories,spec}.{ts,tsx,js,jsx,html}', <--- Skip adding spec/stories files from shared lib

// If you are **not** using `--turbo` you can uncomment both lines 1 & 19.
// A discussion of the issue can be found: https://github.com/nrwl/nx/issues/26510

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './{src,pages,components,app}/**/*.{ts,tsx,js,jsx,html}',
    '!./{src,pages,components,app}/**/*.{stories,spec}.{ts,tsx,js,jsx,html}',
    //     ...createGlobPatternsForDependencies(__dirname)
  ],
  theme: {
    extend: {},
    screens: {
      sm: '576px',   // Bootstrap sm
      md: '768px',   // Bootstrap md
      lg: '992px',   // Bootstrap lg
      llg: '1200px',   // Bootstrap lg
      xl: '1200px',  // Bootstrap xl
      '2xl': '1400px', // Bootstrap xxl
      '3xl': '1700px', // Bootstrap xxl
      'max-3xl': { max: '1699px' }, // custom screen for <=1399px
      'max-xxl': { max: '1399px' }, // custom screen for <=1399px
      'max-xl': { max: '1199px' }, // custom screen for <=1199px
      'max-l': { max: '991px' }, // custom screen for <=991px
      'max-md': { max: '767px' }, // custom screen for <=767px
      'max-mmd': { max: '640px' }, // custom screen for <=640px
      'max-sm': { max: '575px' }, // custom screen for <=575px
      'max-480': { max: '480px' }, // custom screen for <=575px
      'max-ssm': { max: '445px' }, // custom screen for <=445px
      'max-sssm': { max: '390px' }, // custom screen for <=390px
    },
    fontFamily: {
        nunito: ['"Nunito"', 'sans-serif'],
        inter: ['"Inter"', 'sans-serif'],
        icomoon: ['icomoon'],
      },
      letterSpacing: {
        tightish: '0.88px',
      },
      animation: {
      'marquee': 'marquee 40s linear infinite',
      'marquee-reverse': 'marquee-reverse 40s linear infinite',
    },
    keyframes: {
      marquee: {
        '0%': { transform: 'translateX(-50%)' },
        '100%': { transform: 'translateX(0%)' },
      },
      'marquee-reverse': {
        '0%': { transform: 'translateX(0%)' },
        '100%': { transform: 'translateX(-50%)' },
      },
    },
  },
  plugins: [],
};
