import Image from 'next/image'
import Link from 'next/link'

export default function ImportantGuides(){
	return(
		<>
		<section className="important-guides pt-[70px] pb-[124px] bg-[#f5f5f5]">
    <div className="container mx-auto px-4">
        <div className="section-heading max-w-[875px] mx-auto text-center">
            <h2 className="mb-[24px]">All of our important guidelines and policies in one place</h2>
            <p className="text-[#808080] text-center max-sm:text-[14px] max-md:text-[15px] max-l:text-base max-xxl:text-[17px] text-[18px] font-medium leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's.</p>
        </div>
        <div className="guide-cards mt-[83px] flex max-l:flex-col max-l:items-center justify-between gap-y-[30px] gap-x-[10px] ">
            <div className="guide-card w-full max-l:mx-auto max-w-[400px] bg-white rounded-[10px] px-[7px] pt-[10px] pb-[47px]">
                <Image src="/images/guide-image01.jpg" alt=""
                	 className="w-full"
                	 width={384}
                	 height={237}
                />
                <div className="cart-text max-l:mt-[25px] mt-[35px] max-l:px-[10px] max-l:py-[0px] px-[25px]">
                    <h6 className="text-xl font-bold mb-[12px] leading-[1.07]">For Reviewers</h6>
                    <p className="!text-[#808080] text-base font-medium leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. </p>
                    <Link className="primary-link with-arrow max-md:text-base max-md:pr-[0px] !mt-[17px] !pr-[80px] !underline" href="/#">Learn More</Link>
                </div>
            </div>
            <div className="guide-card w-full max-l:mx-auto max-w-[400px] bg-white rounded-[10px] px-[7px] pt-[10px] pb-[47px]">
                <Image src="/images/guide-image02.jpg" alt=""
                	   className="w-full"
                	   width={384}
                	   height={237}	
                />
                <div className="cart-text max-l:mt-[25px] mt-[35px] max-l:px-[10px] max-l:py-[0px] px-[25px]">
                    <h6 className="text-xl font-bold mb-[12px] leading-[1.07]">For Businesses</h6>
                    <p className="!text-[#808080] text-base font-medium leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. </p>
                    <Link className="primary-link with-arrow max-md:text-base max-md:pr-[0px] !mt-[17px] !pr-[80px] !underline" href="/#">Learn More</Link>
                </div>
            </div>
            <div className="guide-card w-full max-l:mx-auto max-w-[400px] bg-white rounded-[10px] px-[7px] pt-[10px] pb-[47px]">
                <Image src="/images/guide-image03.jpg" alt=""
                	   className="w-full"
                	   width={384}
                	   height={237}
                />
                <div className="cart-text max-l:mt-[25px] mt-[35px] max-l:px-[10px] max-l:py-[0px] px-[25px]">
                    <h6 className="text-xl font-bold mb-[12px] leading-[1.07]">For Everyone</h6>
                    <p className="!text-[#808080] text-base font-medium leading-[1.51]">Lorem Ipsum is simply dummy text of the printing and typesetting industry. </p>
                    <Link className="primary-link with-arrow max-md:text-base max-md:pr-[0px] !mt-[17px] !pr-[80px] !underline" href="/#">Learn More</Link>
                </div>
            </div>
        </div>

        <div className="additional-guide py-[56px] px-[30px] bg-white mt-[56px] rounded-[12px]">
            <div className="additional-guide--cards grid max-l:grid-cols-1 grid-cols-2 gap-y-[30px] gap-x-[60px]">
                <div className="info-left pr-[40px] border-r border-[#000000] max-l:pr-[0px] max-l:border-r-[0px] max-l:border-b pb-[30px]">
                    <img className="block__icon w-[51px] mb-[21px]" src="images/icon-privacy-black.svg" alt=""/>
                    <h6 className="mb-[11px] text-base font-bold text-[#323232] leading-[1.20]">We respect our community's privacy</h6>
                    <p className="text-[#808080] max-sm:text-[14px] max-md:text-[15px] max-l:text-base xl:text-base mb-[16px] block">Download our white papers to learn more.</p>
                    <Link className="primary-link with-arrow !text-[#713fff] !text-base max-md:pr-[0px] pr-[80px] !underline mb-[8px] !mt-[0px]" href="/#">GDPR & YourReview</Link>
                    <Link className="primary-link with-arrow !text-[#713fff] !text-base max-md:pr-[0px] pr-[80px] !underline !mt-[0px]" href="/#">Security practices for YourReview Review Invitation Services
                	</Link>
                </div>
                <div className="info-right">
                    <img className="block__icon  w-[51px] mb-[21px]" src="images/icon-say-no-black.svg" alt=""/>
                    <h6 className="mb-[11px] max-sm:text-[14px] max-md:text-[15px] text-base font-bold text-[#323232] leading-[1.20]">We say no to slavery and human trafficking</h6>
                    <p className="text-[#808080] max-l:text-base xl:text-base mb-[16px] block">We honor our obligation to prevent slavery and human trafficking in our business. View our statement to learn more.</p>
                    <Link className="primary-link with-arrow !text-[#713fff] !text-base max-md:pr-[0px] pr-[80px] !underline !mt-[0px]" href="/#">Modern Slavery Statement</Link>
                </div>
            </div>
        </div>

    </div>
</section>
		</>
		);
}