'use client';

import React, { useState } from "react";
import Select, { StylesConfig } from 'react-select';
import Link from 'next/link';
import { products } from "../../data/products";


interface OptionType {
      value: string;
      label: string;
  }

const sortOptions = [
  { value: "Popular Products", label: "Popular Products" },
  { value: "recent", label: "Most recent" },
  { value: "highest", label: "Highest rating" },
  { value: "lowest", label: "Lowest rating" },
];


const customStyles: StylesConfig<OptionType, false> = {
      option: (base, state) => ({
        ...base,
        backgroundColor: state.isSelected
        ? '#f3f3f3'
        : state.isFocused
        ? '#f6f6f6'
        : 'white',
        color: '#343434',
        padding: 10,
        cursor: 'pointer',
        fontSize: '14px',
        fontWeight: state.isSelected ? '700' : '400',
    }),
      control: (base, state) => ({
        ...base,
        width: '100%',
        color: '#343434',
        fontWeight: 700,
        fontSize: 16,
        padding: 0,
        border: '0px solid #e8e8e8',
        borderRadius: 0,
        backgroundColor: 'transparent',
        boxShadow: state.isFocused ? '0 0 0 0px #e8e8e8' : 'none',
        '&:hover': {
          borderColor: 'transparent',
      },
      // Responsive font size
  '@media (max-width: 991px)': {
    fontSize: 14,
  },
  }),
      singleValue: (base) => ({
        ...base,
        maxWidth: '100%',
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        color: '#343434',
        marginLeft: 0,
        padding: 0,
        fontWeight: 700,
    }),
      placeholder: (base) => ({
        ...base,
        display: 'none', // Hides the placeholder (heading-like text)
    }),
      dropdownIndicator: (base, state) => ({
        ...base,
        padding: 0,
        color: '#999',
        transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
        transition: 'transform 0.2s ease',
        svg: {
          fill: '#999',
          stroke: '#999',
          strokeWidth: 0,
      },
  }),
      indicatorSeparator: () => ({
        display: 'none',
    }),
  };

export default function RightListing(){
	const [selectedSort, setSelectedSort] = useState(sortOptions[0]);
	const [view, setView] = useState<'grid' | 'list'>('grid');

	return(
		<>
		<div className="reviews-sort-holder pt-0 flex justify-between items-center pb-[15px]">
            <div className="sort flex items-center gap-0">
                <span className="text-[#6a6a6a] text-sm font-normal leading-[1.07]">Sort by:</span>
		          <Select
		            options={sortOptions}
		            value={selectedSort}
		            onChange={(opt) => opt && setSelectedSort(opt)}
		            classNamePrefix="rs"
		            isSearchable={false}
		            styles={customStyles}
		          />
            </div>
            <div className="product-toggle-wrapper max-md:hidden">
			      {/* Toggle Buttons */}
			      <div className="structure-view flex items-center gap-[10px]" id="cardStructureControl">
			        <button
			          type="button"
			          onClick={() => setView('grid')}
			          className={`grid-view ${view === 'grid' ? 'active' : ''}`}
			          aria-label="Grid View"
			        >
			          <img src="/images/icon-view-grid.svg" alt="Grid View" />
			        </button>
			        <button
			          type="button"
			          onClick={() => setView('list')}
			          className={`list-view ${view === 'list' ? 'active' : ''}`}
			          aria-label="List View"
			        >
			          <img src="/images/icon-view-list.svg" alt="List View" />
			        </button>
			      </div>
			</div>
        </div>

        {/*products*/}

        <div
        className={`product-cards ${
          view === 'grid' ? 'grid-view-structure' : 'list-view-structure'
        }`}
        id="productListingHolder"
      >
                {products.map((product, idx) => (
                    <div key={idx} className="product-card">
                        <Link href={`/products/${product.slug}`} className="details-link">
                            <div className="product-image">
                                <img src={product.image} alt={product.name} />
                            </div>
                        </Link>
                        <div className="card__body">
                            <Link href={`/products/${product.slug}`} className="details-link">
                                <h6>{product.name}</h6>
                            </Link>
                            <p>{product.description}</p>
                            <div className="rating--counts">
                                <div className="review-details">
                                    <span className="rating-count">{product.rating}</span>
                                    <span className="vote-count">({product.votes} votes)</span>
                                </div>
                                <span className="fav-count">{product.fav}</span>
                            </div>
                            <div className="card__footer flex justify-end">
                                <label htmlFor="compare__03" className="font-normal inline-block">Compare</label>
                                <input className="form-check-input small appearance-none" id="compare__03" type="checkbox"/>
                            </div>
                        </div>
                    </div>
                    ))}
                   
                                     
                    
                </div>

                {/*pagination*/}
                <div className="pagination flex justify-between items-center m-0 pt-[48px]">
                    <Link href="/#" className="prev max-md:text-[4px] text-[8px]
                     rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
                     border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
                     <i className="icon-arrow-long-left2">
                     </i></Link>
                     <ul className="flex justify-center items-center gap-y-[3px] gap-x-[5px]">
                      <li><Link className="active flex justify-center items-center 
                        text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">1</Link></li>
                        <li><Link className="flex justify-center items-center 
                          text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">2</Link></li>
                          <li><Link className="flex justify-center items-center 
                            text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">3</Link></li>
                            <li><Link className="flex justify-center items-center 
                              text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">4</Link></li>
                              <li><Link className="flex justify-center items-center 
                                text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">5</Link></li>
                                <li><Link className="flex justify-center items-center 
                                  text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">...</Link></li>
                                  <li><Link className="flex justify-center items-center 
                                    text-base font-bold w-[40px] h-[40px] rounded-full" href="/#">25</Link></li>
                                  </ul>
                                  <Link href="/#" className="next max-md:text-[4px] text-[8px]
                                   rounded-[100px] max-md:leading-[34px] leading-[43px] max-md:w-[50px] w-[93px] max-md:h-[34px] h-[43px]
                                   border border-[#a5b4bc] text-[#a5b4bc] inline-block text-center hover:text-[#713fff] hover:border-[#713fff]">
                                   <i className="icon-arrow-long-right2"></i></Link>
                                 </div>

		</>
		);
}