import Link from 'next/link'

export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner product-listin-banner pt-[140px] pb-[80px] text-center">
		    <div className="container mx-auto px-4">
		        <h1 className="font-extrabold max-xl:text-[54px] !leading-[1.08] 
		        	max-sm:max-w-[320px] max-sm:mx-auto max-sm:text-[36px]">
		        	Beauty & Well-being
		        </h1>
		        <span className="breadcramp text-[#7c7c7c] block mt-[15px]">
		        	Category / <span className="text-[#713fff]">Beauty & Well-being</span> 
		        </span>
		        <form action="/#" name="search-form">
						<div className="site-search !mt-[42px]">
							<input
								type="text"
								placeholder="Search a Business or product Name"
								className="form-control max-md:!leading-[55px] max-md:!text-[14px] max-md:!px-[20px]  
								placeholder-gray-400"
							/>
							<Link href="/#" className="absolute right-[13px] top-1/2 -translate-y-1/2 
								flex items-center justify-center gap-x-1.5 rounded-full bg-[#713fff] 
								text-white font-bold backdrop-blur-sm w-[46px] h-[46px] p-0 min-w-0 md:w-auto 
								md:h-auto md:px-[27px] md:leading-[43px] md:min-w-[130px] md:text-[14px] max-md:right-[8px] 
								hover:bg-[#323232]"> 
								<i className="icon-search max-md:mr-0 mr-[2px]"></i><span className="hidden md:inline">Search</span>
							</Link>
						</div>
					</form>
		    </div>
		</section>
		</>
		);
}