interface StarRatingProps {
  rating: number; 
}

export default function StarRating({ rating }: StarRatingProps) {
  const stars = [];

  for (let i = 1; i <= 5; i++) {
    if (rating >= i) {
      stars.push("/images/rating-star-full.svg");
    } else if (rating >= i - 0.5) {
      stars.push("/images/rating-star-half.svg");
    } else {
      stars.push("/images/rating-star-blank.svg");
    }
  }

  return (
    <>
    <div className="star-icons flex max-xxl:w-[35%] w-[30%] max-md:w-[70%]">
    <ul className="flex items-center gap-[2px] w-auto p-0 mr-0 rounded-[20px] leading-0 
      max-md:p-[4px_7px_4px_0px]">
      {stars.map((src, index) => (
        <li key={index}>
          <img
            className="star-rating-icon max-md:h-[22px] h-[32px]"
            src={src}
            alt={`Star ${index + 1}`}
          />
        </li>
      ))}
    </ul>
  </div>
  </>
  );
}
