'use client';

import React, { useState } from 'react';
import Select from 'react-select';
import StarRating from './StarRating'

interface ProductRatingTableProps {
  rating: number;
  votes: number;
  fav: string;
}

interface OptionType {
  value: string;
  label: string;
}

const ratingOptions: OptionType[] = [
  { value: '2025- Wise Rating', label: '2025- Wise Rating' },
  { value: '2024- Wise Rating', label: '2024- Wise Rating' },
  { value: '2023- Wise Rating', label: '2023- Wise Rating' },
  { value: '2022- Wise Rating', label: '2022- Wise Rating' },
];

const customStyles = {
  control: (base: any) => ({
    ...base,
    width: 'auto',
    height: '42px',
    backgroundColor: '#fff',
    border: 'solid 1px #e8e8e8',
    borderRadius: '5px',
    paddingLeft: '2px',
    paddingRight: '5px',
    color: '#969696',
    fontSize: '14px',
    fontWeight: '400',
    lineHeight: '40px',
    boxShadow: 'none',
    '@media (max-width: 575px)': {
    width: '100% !important',
  },
  }),
  option: (base: any, state: any) => ({
    ...base,
    backgroundColor: state.isSelected
        ? '#f3f3f3'
        : state.isFocused
        ? '#f6f6f6'
        : 'white',
    color: '#343434',
    fontWeight: state.isSelected ? '700' : '400',
    fontSize: '14px',
    paddingLeft: 18,
    paddingRight: 29,
    lineHeight: '20px',
    cursor: 'pointer',      
  }),
  singleValue: (base: any) => ({
    ...base,
    color: '#343434',
  }),
  indicatorSeparator: () => ({
    display: 'none',
  }),
  dropdownIndicator: (base: any, state: any) => ({
    ...base,
    color: '#999',
    transform: state.selectProps.menuIsOpen ? 'rotate(180deg)' : 'rotate(0deg)',
    transition: 'transform 0.2s ease',
  }),
};



export default function ProductRatingTable(props: ProductRatingTableProps){
	  const [selectedOption, setSelectedOption] = useState<OptionType | null>(ratingOptions[0]);
      const { rating, votes, fav } = props;

	return(
		<>
		<div className="rating-detail-table rounded-[7px] border border-[#e4e0ee] bg-[#f4f8fe]">
            <div className="table-heading w-full flex justify-between items-center bg-[#ecf4ff] border-b border-[#ecf4ff]
            	p-[10px_14px_10px_23px] rounded-[7px_7px_0px_0px] max-sm:p-[10px] max-sm:flex-col max-sm:items-start">
                <h6 className="text-[#323232] text-base font-semibold !leading-[1.47]">
                	MouthShut Score
                </h6>
                <div className="action--right flex justify-end items-center gap-x-[17px] gap-y-[10px]
                    max-sm:w-full max-sm:flex-col max-sm:items-start max-sm:mt-[15px]">
                    <label htmlFor="followers-count" className="text-[#666] inline-block">0 Followers</label>
                    <Select
				      options={ratingOptions}
				      value={selectedOption}
				      onChange={(option) => setSelectedOption(option)}
				      isSearchable={false}
				      styles={customStyles}
				      classNamePrefix="rs"
				    />
                </div>
            </div>
            <div className="table-body flex items-center py-[15px] px-[21px] 
                max-xl:flex-wrap gap-y-[15px]">
                    <StarRating rating={rating} />
                <div className="fav-count max-md:text-left max-md:w-[30%] w-[15%] flex justify-center items-center gap-[5px]">
                    <img className="max-md:h-[20px] h-[26px]" src="/images/icon-favheart.svg" alt=""/>
                    <span className="text-[#666] text-base font-medium">{fav}</span>
                </div>
                <div className="score">
                    <input className="score-input w-[90px] height-[33px] leading-[33px] rounded-[5px] border border-[#d9d4e6]
                        bg-white px-[14px] text-[#666]" 
                        type="text" value="2.98" name="" id="" readOnly/>
                </div>
                <div className="vote text-[#666] text-base font-medium !leading-[1.07] max-md:ml-[10px] ml-[35px]">
                    <span>{votes} votes</span>
                </div>
            </div>
        </div>
		</>
		);
}