"use client";

import { useKeenSlider } from "keen-slider/react";
import "keen-slider/keen-slider.min.css";
import Image from 'next/image'

export default function ImageGallery() {
  const [sliderRef, slider] = useKeenSlider({
    loop: true,
    breakpoints: {
      "(min-width: 640px)": {
        slides: { perView: 1, spacing: 10 },
      },
      "(min-width: 1024px)": {
        slides: { perView: 1, spacing: 20 },
      },
    },
    slides: { perView: 1, spacing: 10 },
  });

  const handlePrev = () => slider.current?.prev();
  const handleNext = () => slider.current?.next();

  return (
    <>
    <section className="story-image-gallery bg-[#f4f4f4] mt-[80px]">
      <div className="container mx-auto px-4">
        <div className="our-stories-slide relative max-xxl:w-[95%] mx-auto mb-[-80px] max-l:w-full w-full">
          {/* Slider */}
          <div ref={sliderRef} className="keen-slider">
            {Array.from({ length: 12 }).map((_, index) => (
              <div key={index} className="keen-slider__slide">
                <Image
                  src="/images/story-gallery_image.jpg"
                  alt={`Story ${index + 1}`}
                  width={1296}
                  height={600}
                  className="w-full h-full object-cover rounded-[8px] shadow-sm"
                />
              </div>
              ))}
          </div>

          {/* Navigation Arrows */}
          <div className="slide-nav"> 
            <button
              onClick={handlePrev}
              className="max-l:w-[65px] max-l:h-[65px] max-xxl:w-[80px] max-xxl:h-[80px] w-[105px] h-[105px] text-[28px] max-xxl:text-[26px] text-[#ffffff]  bg-[#713fff] rounded-full shadow-md hover:bg-[#8d65ff] transition"
              aria-label="Previous"
            >
              <i className="icon-arrow-left2"></i>
            </button>
            <button
              onClick={handleNext}
              className="max-l:w-[65px] max-l:h-[65px] max-xxl:w-[80px] max-xxl:h-[80px] w-[105px] h-[105px] text-[28px] max-xxltext-[26px] text-[#ffffff]  bg-[#713fff] rounded-full shadow-md hover:bg-[#8d65ff] transition"
              aria-label="Next"
            >
              <i className="icon-arrow-right2"></i>
            </button>
          </div>
        </div>
      </div>
    </section>
    </>
    );
}
