import Link from 'next/link'

export default function ReviewCategories(){
	return (
		<>
			<section className="categories-overview pt-[70px] pb-[60px] bg-[#f5f5f5]">
				  <div className="container mx-auto px-4 2xl:max-w-[1590px] 2xl:px-[15px]">
				    <h2 className="font-bold text-center text-[#323232] mb-[50px]">
				      Explore Our Review Categories
				    </h2>

				    <div className="flex flex-wrap justify-center items-stretch max-xl:gap-[12px] gap-[15px] category-card">
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-animals.svg" alt="Animals" 
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Animals & Pets</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-beauty.svg" alt="Beauty"
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Beauty & Well-being</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-business.svg" alt="Business" 
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Business Services</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img
				        	src="/images/icon-categery-construction.svg" alt="Construction"
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Construction & Manufacturing</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-education.svg" alt="Education" 
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Education & Training</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-electrics.svg" alt="Electronics" 
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Electronics & Technology</h6>
				      </div>
				      <div className="flex flex-col items-start w-40 max-xl:!h-auto max-xl:!w-[160px] max-xl:!py-[25px] max-xl:!px-[20px]
				      	hover:shadow-[0px_0px_0px_7px_rgba(129,129,129,0.11)] hover:border-[#e5e5e5] border transition-all duration-300">
				        <img 
				        	src="/images/icon-categery-events.svg" alt="Events" 
				        	className="mb-[15px] max-l:h-[32px] max-xl:h-[42px]  h-[50px]" />
				        <h6 className="max-l:text-[15px] max-xl:text-base text-lg font-semibold leading-[1.20]">Events & Entertainment</h6>
				      </div>
				    </div>

				    <div className="text-center mt-[48px]">
				      <Link
				        href="/category-listings"
				        className="max-md:text-base text-lg font-semibold text-[#323232] relative"
				      >
				        See all categories
				      </Link>
				    </div>
				  </div>
				</section>
		</>
		);
}