import Link from 'next/link'

export default function QuickContact() {
	return (
			<>
			<section className="quick-contact">
		      <div className="container mx-auto px-4">
		        <div className="flex flex-col lg:flex-row items-center max-md:gap-y-[0px] gap-6">
		          <div className="w-full md:w-1/2 text-center">
		            <Link className="ms-btn primary-solid btn-xl primary-button !max-w-[500px] max-l:!text-[16px] max-l:!py-[22px] 
		            	max-l:!px-[30px] hover:bg-[#713fffcc]" href="/help-center">
		              Need Support
		            </Link>
		          </div>
		          <div className="w-full md:w-1/2">
		            <div className="support-content max-md:pl-[15px] pl-[30px]">
		              <span className="heading-label !font-extrabold llg:!text-[36px]">Get Assistance:</span>
		              <h3 className="help-center !font-bold max-sm:text-[28px] max-md:text-[32px] llg:!text-[45px]">Explore Our Help Center</h3>
		            </div>
		          </div>
		        </div>
		      </div>
		    </section>
			</>
		);
}