import Image from 'next/image'
export default function FeedbackOverview() {
	return (
		<>
		<section className="feedback-overview pt-[70px] pb-[75px]">
		    <div className="container mx-auto px-4">
		        <h2 className="!font-bold !pb-[50px]">Superior Customer Feedback Solutions for Business Growth</h2>
		        <div className="row flex flex-wrap -mx-3 -mt-6">
		            <div className="w-full lg:w-1/2 px-3 mt-6">
		                <div className="business-overview !pt-[80px] !pb-[80px]">
		                	<div className="business-top">
			                    <p className="text-[#808080] text-center px-[10px] text-lg font-normal !leading-[1.43]
			                    	max-sm:!text-sm max-md:!text-[15px] max-l:!text-base">
			                    	Unlock the potential of customer feedback with Your.Reviews, where we provide comprehensive 
							          solutions tailored for enhancing business growth through authentic and insightful reviews. 
							          Our platform is designed to help businesses like yours leverage customer feedback to improve products, 
							          services, and overall customer satisfaction.
							    </p>
							</div>
		                    <div className="counts-holder relative flex justify-around
		                    	max-l:flex-col max-l:gap-y-[30px] !mt-[60px]">
		                        <div className="count flex gap-[32px] pr-[15px]
		                        	max-l:justify-center items-center">
		                            <Image 
						            	src="/images/icon-gray-business.svg" alt="Business Icon"
						            	width={62} 
						            	height={62} 
						            	className="max-xl:w-[50px] max-xl:h-[50px]"
						            />
		                            <h5 className="max-xl:!text-xl">2K +<span className="max-xl:!text-[20px]">
		                            	Business</span></h5>
		                        </div>
		                        <div className="count flex gap-[32px] pr-[15px]
		                        	max-l:justify-center items-center">
		                            <img 
						            	src="/images/icon-gray-product.svg" alt="Product Icon" 
						            	width={62} 
						            	height={62}
						            	className="max-xl:w-[50px] max-xl:h-[50px]"
						            />
		                            <h5 className="max-xl:!text-xl">1K +<span className="max-xl:!text-[20px]">
		                            	Products</span></h5>
		                        </div>
		                    </div>
		                </div>
		            </div>
		            <div className="w-full lg:w-1/2 px-3 mt-6">
		                <div className="reviews-overview max-sm:!p-5 !pt-[50px] !pb-[95px]">
		                	<div className="reviews-top">
		                    <h4 className="max-md:!text-[26px] max-xl:!text-[30px]">Reviews overview</h4>
		                    <ul className="flex justify-center items-center mb-[10px]">
		                        <li className="!left-[20px]">
				          	<Image 
				          	src="/images/profile-image-1.jpg" alt="" 
				          	width={100} 
				            height={100}
				          	className="max-l:!w-[60px] w-[50px] rounded-full" />
				          </li>
				          <li className="!left-[10px]">
				          	<Image 
				          	src="/images/profile-image-2.jpg" alt=""
				          	width={100} 
				            height={100}
				            className="max-l:!w-[60px] w-[75px] rounded-full"
				          	/>
				          </li>
				          <li>
				          	<img 
				          	src="/images/profile-image-3.jpg" alt=""
				          	width={100} 
				            height={100}
				          	className="max-l:!w-[60px] w-25 rounded-full" />
				          </li>
				          <li className="!left-[-10px]">
				          	<Image 
				          	src="/images/profile-image-4.jpg" alt=""
				          	width={100} 
				            height={100} 
				          	className="max-l:!w-[60px] w-[75px] rounded-full" />
				          </li>
				          <li className="!left-[-20px]">
				          	<Image src="/images/profile-image-5.jpg" alt=""
				          	width={100} 
				            height={100} 
				          	className="max-l:!w-[60px] w-[50px] rounded-full" />
				          </li>
				        </ul>
		                    <p className="max-sm:!w-full">
					          Gain insights from a diverse community to enhance satisfaction and business growth.
					        </p>
					    </div>
		                    <div className="counts-holder flex justify-center gap-[20px] mt-[50px]">
		                        <div className="count">
		                            <span className="max-sm:text-[24px] text-[32px] not-italic text-[#030202] font-bold leading-[147%]">
		                            	10M +
		                            </span>
		                            <span className="review-caption block text-[#808080]">Reviews</span>
		                        </div>
		                        <div className="count">
		                            <span className="max-sm:text-[24px] text-[32px] not-italic text-[#030202] font-bold leading-[147%]">
		                            	1M +
		                            </span>
		                            <span className="review-caption block text-[#808080]">Users</span>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>	
		</>
		);
}