import Image from 'next/image'
import Link from 'next/link'

export default function EasyControl() {
  return (
    <section className="easy-control pt-[85px] pb-[70px] bg-white">
      <div className="container mx-auto px-4">
        <div className="flex flex-wrap gap-y-12 -mx-3">
          {/* Left Column - Image */}
          <div className="w-full lg:w-1/2 px-3">
            <div className="easy-control-image">
              <Image
                src="/images/control-panel-image.jpg"
                alt="Control Panel"
                width={624}
                height={383}
                className="w-full h-auto"
              />
            </div>
          </div>

          <div className="w-full lg:w-1/2 max-xl:pr-[0px] px-3">
            <div className="easy-control-content max-l:!mt-[0px] max-xl:!pl-0 !pl-[70px]">
              <h2 className="easy-control-heading max-xxl:mb-[10px] mb-[20px] 2xl:!text-[52px] llg:text-[38px]">
                Effortless Management Made Simple!
              </h2>
              <p className="control-text max-sm:text-[14px] max-l:text-base max-l:tracking-[-.1px] max-xxl:text-[16px] 
                max-xxl:!leading-[1.37]">
                Your.Reviews simplifies how businesses collect, organize, and analyze customer feedback. 
                Our intuitive, AI-driven platform makes managing reviews effortless while ensuring security, 
                efficiency, and adaptability. Gain insights, improve engagement, and build trust—all from one 
                user-friendly dashboard.
              </p>
              <div className="text-center mt-[40px]">
                <Link className="ms-btn primary-solid btn-xl primary-button max-l:!text-[16px] max-l:!py-[22px] max-l:!px-[30px]
                  hover:bg-[#713fffcc]" href="/contact-sales">
                  Get Started
                </Link>
              </div>
            </div>
          </div>

          <div className="w-full px-3 lg:mt-[20px]">
            <ul className="easy-control-benefits grid grid-cols-1 xl:grid-cols-4 gap-[24px] text-[#323232] font-bold">
              <li className="max-sm:!text-[15px] !text-[16px]"><b>Integrated Dashboard:</b> View and manage all your 
                reviews in one centralised location.</li>
              <li className="max-sm:!text-[15px] !text-[16px]"><b>Secure Data Handling:</b> Your data is protected 
                with advanced encryption and privacy controls.</li>
              <li className="max-sm:!text-[15px] !text-[16px]"><b>Customizable Features:</b> Adapt the platform to 
                meet your business’s unique needs and objectives.</li>
              <li className="max-sm:!text-[15px] !text-[16px]"><b>Efficient Reporting:</b> Track trends, analyse sentiment, 
                and generate detailed reports instantly.</li>
            </ul>
          </div>
        </div>
      </div>
    </section>
  );
}
