	import Image from 'next/image'
	import Link from 'next/link'

	export default function BetterPricing() {
		return (
			<>
			<section className="pb-10 brief-better-pricing">
				<div className="container mx-auto px-4">
					<div className="flex flex-col lg:flex-row gap-12 items-start section-holder">
						<div className="lg:w-7/12">
							<div className="section-content">
								<h2 className="mb-[20px]">
									Better Pricing Than Other Competitors
								</h2>
								<p className="max-sm:text-[14px] max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] 
									2xl:text-[18px] sm:tracking-[-0.2px]">
									Your.Reviews offers top-tier review management at a fraction of the cost. 
									Our pricing is transparent, flexible, and designed to provide businesses 
									with the best value. No hidden fees, just an affordable way to manage and 
									enhance your online reputation while saving money.
								</p>
								<div className="text-center">
									<Link
										href="/#"
										className="ms-btn primary-solid btn-xl primary-button max-l:!text-[16px] max-l:!py-[22px] 
										mt-[45px] hover:bg-[#713fffcc]">
										Get Started
									</Link>
								</div>
							</div>
						</div>
						<div className="lg:w-5/12 flex justify-center">
							<Image 
								src="images/image-better-pricing.svg" alt="Better Pricing"
								width={552}
								height={437}
								className="w-full max-w-[480px] h-auto section-image" />
							</div>
						</div>
					</div>
				</section>
				</>
				);
	}