'use client';
import { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";

const faqs = [
  {
    question: "What types of reviews does your platform support?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How does your AI detect fake reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can businesses respond to reviews on your platform?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "Can users report suspicious reviews?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
  {
    question: "How can businesses integrate your review analysis into their systems?",
    answer:
      "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
  },
];

export default function FAQSection() {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  const toggleIndex = (index: number) => {
    setOpenIndex(openIndex === index ? null : index);
  };

  return (
      <>
            <div className="faq-wrapper block w-full mt-[42px]">
            {faqs.map((faq, index) => (
                <div
                  key={index}
                  className="faq-item w-full block my-[10px] max-sm:pl-[17px] pl-[25px] !rounded-[13px] bg-white"
                >
                  <div
                    className="faq-question flex gap-[18px] items-baseline"
                    onClick={() => toggleIndex(index)}
                  >
                    <img
                      src={openIndex === index ? "/images/faq-active.svg" : "/images/faq-inactive.svg"}
                      alt={openIndex === index ? "Collapse" : "Expand"}
                      className="shrink-0 max-sm:hidden w-[16px] h-[16px]"
                    />
                    <h4 className="max-xl:p-[20px_18px_20px_5px] p-[18px_50px_18px_5px] 
                      text-[#1c070c] max-md:text-[16px] max-xl:text-[18px] text-[20px] relative font-semibold">
                      {faq.question}
                    </h4>
                  </div>

                  <AnimatePresence initial={false}>
                    {openIndex === index && (
                      <motion.div
                        initial={{ height: 0, opacity: 0 }}
                        animate={{ height: "auto", opacity: 1 }}
                        exit={{ height: 0, opacity: 0 }}
                        transition={{ duration: 0.3 }}
                        className="overflow-hidden max-sm:pl-[0px] mt-[-10px] pb-[25px] pl-[40px] max-l:pr-[40px] pr-[48px]"
                      >
                        <p className="text-gray text-[16px] leading-[1.54] mt-2">{faq.answer}</p>
                      </motion.div>
                    )}
                  </AnimatePresence>
                </div>
            ))}
          </div>
         </>   
          
  );
}
