import Link from 'next/link'
export default function InnerBanner(){
	return(
		<>
		<section className="inner-banner features-banner text-center  
			max-sm:pb-[50px] max-md:pb-[60px] max-xl:pb-[80px] pt-[140px] pb-[108px]">
			<div className="container mx-auto px-4 text-center">
				<div className="container--wraper">

					<h1 className="font-extrabold max-xl:text-[54px] max-sm:text-[36px] leading-[1.08] 
						max-w-[850px] mx-auto">
						Invite your brand to engage in the dialogue
					</h1>
					<p className="text-[#343434] text-center font-inter max-md:text-base text-xl font-semibold leading-[147%] mb-[25px] mt-[15px]">
						Compare the best product in this category
					</p>

					<form action="/#" name="search-form">
						<div className="site-search flex flex-col justify-center items-center gap-4 !mt-[42px]">
							<input
								type="text"
								placeholder="Search a Business or product Name"
								className="form-control w-full max-md:!text-[14px] max-md:!leading-[55px] max-md:!px-[20px] py-2 border border-gray-300 rounded-md focus:outline-none 
								focus:ring-2 focus:ring-blue-500"
							/>
							<Link href="/business-listing" className="absolute max-md:right-[8px] right-[13px] top-1/2 -translate-y-1/2 
								flex items-center justify-center gap-x-1 rounded-full bg-[#713fff] 
								text-white font-bold backdrop-blur-sm w-12 h-12 p-0 min-w-0 md:w-auto 
								md:h-auto md:px-[27px] md:leading-[43px] md:min-w-[130px] md:text-[14px] hover:bg-[#323232]" > 
								<i className="icon-search max-md:text-[16px] max-md:mr-0 mr-[5px]"></i> 
									<span className="hidden md:inline">Search</span> 
								</Link>

						</div>
					</form>
				</div>
			</div>
		</section>
		</>
		);
}