import Link from 'next/link' 

export default function DidYouKnow() {
	return(
		<>
		<section className="did-you-know max-l:pt-[30px] max-xl:pt-[50px] max-xxl:pt-[65px] pt-[77px] pb-[175px] bg-[#f5f5f5]">
		    <div className="container mx-auto px-4">
		        <div className="heading-content max-md:flex-col max-md:gap-y-[20px] max-w-[1172px] mx-auto flex">
		            <div className="heading-content--image max-md:w-[100%] max-xl:w-[30%] w-[20%] max-md:text-left text-center">
		                <img src="images/vector-didyouknow.svg" alt=""
		                	 className="w-full max-w-[206px]"
		                />
		            </div>
		            <div className="heading-content--text max-md:w-full max-md:pl-0 max-xl:w-[70%] w-[80%] pl-[50px] max-w-[806px]">
		                <span className="heading-label block text-[#713fff] pb-[13px] max-md:text-base text-lg
		                	font-semibold leading-[1.40] uppercase">
		                	Did you know?
		                </span>
		                <h3 className="mb-[15px] max-sm:text-[28px] max-md:text-[32px] max-xl:text-[36px] text-[40px] font-nunito font-bold text-[#323232] leading-[1.20]">
		                	Verified reviews from <span className="text-[40px] font-bold leading-[1.20] text-[#713fff]">
		                		YourReview </span> 
		                	count toward your Google Seller Rating.
		                </h3>
		                <Link className="primary-link with-arrow max-l:p-[0px] max-l:!text-[18px] !mt-0 !text-xl !underline
		                 pr-[80px] font-semibold inline-block 
		                	text-[#323232] relative" href="/#">
		                	Seller ratings boost CTR on your Google ads by up to 10%</Link>
		            </div>
		        </div>

		        <div className="article-block business-profile max-md:py-[30px] max-md:px-[20px] max-l:p-[30px] mt-[65px] py-[60px] px-[93px] bg-[#ffffffb3]
		        	flex items-center rounded-[29px] border-none max-xl:gap-0">
		            <div className="row flex flex-wrap -mx-3 max-l:justify-center">
		                <div className="lg:w-7/12 px-3">
		                    <div className="article-block--content max-xl:pt-[30px] max-xl:pb-[30px]">
		                        <span className="heading-label block text-[#713fff] mb-[13px] max-md:text-base text-lg font-semibold leading-[1.40] 
		                        	uppercase">Business profile page</span>
		                        <h2 className="mb-[15px] font-nunito font-bold text-[#323232]
		                        	leading-[1.20]">Catch the eye of future customers
		                        </h2>
		                        <p className="max-w-[610px] max-sm:text-sm max-md:text-[15px] max-l:text-[16px] max-xxl:text-[17px] text-lg text-[#6d6d6d]
		                         font-normal leading-[1.58]">
		                            Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been
		                            the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
		                            of type and scrambled it to make a type specimen book.
		                        </p>
		                    </div>
		                </div>
		                <div className="lg:w-5/12 px-3">
		                    <figure className="article-block--image w-auto text-center">
		                        <img src="images/catch-the-eye-of-future-customers.svg" alt=""
		                        	 className="w-[330px] max-w-full mx-auto"
		                        />
		                    </figure>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
		</>
		);
}