import Image from 'next/image'
import Link from 'next/link' 

export default function AiAnalysis() {
	return (
		<>
			<section className="pt-[60px] brief-ai-analysis">
			  <div className="container mx-auto px-4">
			  	<div className="section-holder">
			    <div className="flex flex-wrap -mx-3 -mt-12">
			      <div className="lg:w-7/12 px-3 mt-12">
			        <div className="section-content">
			          <h2 className="mb-5 max-xxl:tracking-[-1px]">
			            Detecting Deception: <br></br>Our <span className="ai_class">AI</span> Review Analysis
			          </h2>
			          <p className="max-sm:!text-sm max-md:!text-[15px] max-l:!text-base 2xl:!text-lg !text-[#6d6d6d]
			          	2xl:max-w-[640px]">
			          	Your.Reviews utilises cutting-edge AI to detect fraudulent reviews with precision. By analysing 
			          	patterns, sentiment, and user behaviour, our system uncovers inconsistencies, ensuring only genuine 
			          	customer feedback is displayed. Strengthen your business reputation with accurate, trustworthy reviews 
			          	powered by advanced AI technology.
			          </p>
			          <ul className="ai-list max-md:!gap-y-[20px] !justify-start !items-start">
			            <li className="max-md:!w-full">
			              <img src="images/icongray-sentiment_analysis.svg" alt="" className="max-xl:h-[48px]" />
			              <span className="!text-[16px] 2xl:!text-xl tracking-[-.1px]">
			              	Advanced Sentiment Analysis
			              </span>
			              
			            </li>
			            <li className="max-md:!w-full">
			              <img src="images/icongray-machine_leaning.svg" alt="" className="max-xl:h-[48px]" />
			              <span className="!text-[16px] 2xl:!text-xl">Machine Learning Algorithms
			              	</span>
			            </li>
			            <li className="max-md:!w-full">
			              <img src="images/icongray-data_analysis.svg" alt="" className="max-xl:h-[48px]" />
			              <span className="!text-[16px] 2xl:!text-xl">Historical Data Analysis
			              </span>
			            </li>
			            <li className="max-md:!w-full">
			              <img src="images/icongray-user_behavior_analysis.svg" alt="" className="max-xl:h-[48px]" />
			              <span className="!text-[16px] 2xl:!text-xl">User Behavior Analysis
			              </span>
			            </li>
			          </ul>
			          <Link href="/#" className="primary-link max-md:text-base">
			            Know more about AI features
			          </Link>
			        </div>
			      </div>
			      <div className="lg:w-5/12 px-3 mt-12
			      	flex  2xl:items-center max-xxl:items-start">
				        <Image
				          src="/images/image-ai_review_analysis.svg"
				          alt="AI Review Analysis"
				          width={518}
			              height={530}
			              priority
				          className="section-image 2xl:relative 2xl:left-[-20px]"
				        />
			      </div>
			    </div>
			</div>
			  </div>
			</section>
		</>
		);
}